% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ham_distance.R
\name{ham_distance}
\alias{ham_distance}
\title{Hamiltonian distance matrix creation}
\usage{
ham_distance(hamil_df)
}
\arguments{
\item{hamil_df}{a data frame containing two columns, one for network ID and
another containing Hamiltonian values}
}
\value{
the Hamiltonian distance matrix to be used as input for the kernel function
}
\description{
Description of the Hamiltonian distance matrix creation function.
}
\details{
This function creates a distance matrix using the Hamiltonian output values
from a community detection algorithm that implements a Hamiltonian value,
such as the hierarchical multimodal spinglass algorithm. To ensure a
positive, semi-definite matrix (as required for the kernel function), the
absolute difference between Hamiltonian values is calculated.

The function returns an m x m matrix (where m is the number of networks) to
be used as input for the kernel function.
}
\examples{
hamil_df <- data.frame(id  = seq(1:8),
                       ham = c(-160.5375, -167.8426, -121.7128, -155.7245,
                               -113.9834, -112.5262, -117.9724, -171.374))

ham_distance(hamil_df)

}
\seealso{
\code{\link{hms}}
}
