% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tension.R
\name{tension}
\alias{tension}
\title{The tension spring computer model}
\usage{
tension(x1, x2, x3)
}
\arguments{
\item{x1}{A scalar value between 0.05 and 2, inclusive, controlling the wire diameter.}

\item{x2}{A scalar value between 0.25 and 1.3, inclusive, controlling the mean coil diameter.}

\item{x3}{A scalar value between 2 and 15, inclusive, controlling the number of active coils.}
}
\value{
The evaluation of running the tension spring computer model at input (x1, x2, x3).
\itemize{
  \item obj:  A scalar objective function value
  \item con:  A vector of constraint function values
}
}
\description{
The tension spring computer model is designed to minimize the weight of a tension spring. The three inputs to the computer model are the wire diameter (x1), mean coil diameter (x2), and the number of active coils (x3).
The tension spring weight is subject to four constraints on the shear stress, surge frequency, and deflection.
}
\note{
A solution is feasible only if of all of the constraint functions values are less than or equal to 0.
}
\examples{
### Running the function at x1 = 1, x2 = 1, x3 = 3.
### obj = 5 and con = (1,45.82,-1,0.33)
### (x1,x2,x3) = (1,1,3) is not a feasible solution

tension(1,1,3)
}
