% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcEnthalpy.R
\name{calcEnthalpy}
\alias{calcEnthalpy}
\title{Calculate Enthalpy}
\usage{
calcEnthalpy(Temp, RH, ...)
}
\arguments{
\item{Temp}{Temperature (°Celsius)}

\item{RH}{Relative Humidity (0-100\%)}

\item{...}{Additional arguments to supply to \code{\link{calcPws}} and \code{\link{calcMR}}}
}
\value{
h Enthalpy (kJ/kg)
}
\description{
Function to calculate enthalpy from temperature (°C) and relative humidity (\%).

Enthalpy is the total heat content of air, combining sensible (related to temperature)
and latent heat (related to moisture content), used in HVAC calculations.
Enthalpy is the amount of energy required to bring a gas to its current state
from a dry gas at 0°C.
}
\examples{
# Enthalpy at at 20°C (Temp) and 50\% relative humidity (RH)
calcEnthalpy(20, 50)


# mydata file
filepath <- data_file_path("mydata.xlsx")
mydata <- readxl::read_excel(filepath, sheet = "mydata", n_max = 5)

mydata |> dplyr::mutate(Enthalpy = calcEnthalpy(Temp, RH))


}
