% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcHR.R
\name{calcHR}
\alias{calcHR}
\title{Calculate Humidity Ratio}
\usage{
calcHR(Temp, RH, P_atm = 1013.25, B = 621.9907, ...)
}
\arguments{
\item{Temp}{Temperature (°Celsius)}

\item{RH}{Relative Humidity (0-100\%)}

\item{P_atm}{Atmospheric pressure = 1013.25 (hPa)}

\item{B}{B = 621.9907 g/kg for air}

\item{...}{Additional arguments to supply to \code{\link{calcPws}} and \code{\link{calcMR}}}
}
\value{
HR Humidity ratio (g/kg)
}
\description{
Function to calculate humidity ratio (g/kg) from temperature (°C) and relative humidity (\%).

Humidity ratio is the mass of water vapor present in a given volume of air
relative to the mass of dry air. Also known as "moisture content".

Function uses \code{\link{calcMR}}
}
\note{
This function requires the \code{\link{calcMR}} function to be available in the environment.
}
\examples{
# Humidity ratio at 20°C (Temp) and 50\% relative humidity (RH)
calcHR(20, 50)


# mydata file
filepath <- data_file_path("mydata.xlsx")
mydata <- readxl::read_excel(filepath, sheet = "mydata", n_max = 5)

mydata |> dplyr::mutate(HumidityRatio = calcHR(Temp, RH))


}
\seealso{
\code{\link{calcMR}} for calculating mixing ratio

\code{\link{calcAD}} for calculating air density

\code{\link{calcPw}} for calculating water vapour pressure

\code{\link{calcPws}} for calculating water vapour saturation pressure
}
