% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CC_with_robScore_functions.R
\name{cc_cluster_count}
\alias{cc_cluster_count}
\title{Count the number of clusters based on stability score.}
\usage{
cc_cluster_count(CM, plot.cdf = TRUE, plot.logit = FALSE)
}
\arguments{
\item{CM}{list of consensus matrices each for a specific number of clusters.
It can be the output of \code{consensus_matrix()} and \code{multiview_consensus_matrix()} functions.}

\item{plot.cdf}{binary value to plot the cumulative distribution functions of \code{CM} (default \code{TRUE}).}

\item{plot.logit}{binary value to plot the logit model of cumulative distribution functions of \code{CM} (default \code{FALSE}).}
}
\value{
results as a list:
\code{"LogitScore", "PAC", "deltaA", "CMavg"},
\code{"Kopt_LogitScore", "Kopt_PAC", "Kopt_deltaA", "Kopt_CMavg"}
}
\description{
Count the number of clusters based on stability score.
}
\details{
Count the number of clusters given a list of consensus matrices each for a specific number of clusters.
Using different methods: \code{"LogitScore", "PAC", "deltaA", "CMavg"}
}
\examples{
X = gaussian_clusters()$X
Adj = adj_mat(X, method = "euclidian")
CM = consensus_matrix(Adj, max.cluster=3, max.itter=10)
Result = cc_cluster_count(CM, plot.cdf=FALSE)

}
