% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{spect_clust_from_adj_mat}
\alias{spect_clust_from_adj_mat}
\title{Spectral clustering from adjacency matrix}
\usage{
spect_clust_from_adj_mat(
  adj.mat,
  k = 2,
  max.eig = 10,
  alpha = 1,
  adj.conv = TRUE,
  do.plot = FALSE
)
}
\arguments{
\item{adj.mat}{adjacency matrix}

\item{k}{number of clusters (default=2)}

\item{max.eig}{maximum number of eigenvectors in use (dafaut = 10).}

\item{alpha}{soft threshold (considered if \code{adj.conv = TRUE}) (default = 1)}

\item{adj.conv}{binary value to apply soft thresholding (default = \code{TRUE})}

\item{do.plot}{binary value to do plot (dafaut = \code{FALSE})}
}
\value{
vector of clusters
}
\description{
Spectral clustering from adjacency matrix
}
\details{
apply PAM (k-medoids) clustering on the adjacency matrix
}
\examples{
Adj_mat = rbind(c(0.0,0.9,0.0),
                c(0.9,0.0,0.2),
                c(0.0,0.2,0.0))
hir_clust_from_adj_mat(Adj_mat)

}
