% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GamePropertyDegeneration.R
\name{isDegenerateGame}
\alias{isDegenerateGame}
\alias{isInEssentialGame}
\alias{isInessentialGame}
\title{Check if game is degenerate}
\usage{
isDegenerateGame(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
\code{TRUE} if the game is degenerate, else \code{FALSE}
}
\description{
Checks if a TU game is degenerate.
We call a game essential if the value of the grand coalition is    
greater than the sum of the values of the singleton coalitions.
We call a game degenerate (or inessential), if \deqn{v(N) = \sum v({i})}.
}
\examples{
library(CoopGame)
isDegenerateGame(c(1,2,3,4,4,4,6))

\donttest{
#The following game, i.e. the Maschler game, is not degenerate
library(CoopGame)
v1 <- c(0,0,0,60,60,60,72)
isDegenerateGame(v1) 

#The following game is also not degenerate
library(CoopGame)
v2 <- c(30,30,15,60,60,60,72)
isDegenerateGame(v2)

#The following game is degenerate
library(CoopGame)
v3 <- c(20,20,32,60,60,60,72)
isDegenerateGame(v3)
}

}
\author{
Michael Maerz

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
