% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc_scmprisk_Cox.R
\name{rc_scmprisk_Cox}
\alias{rc_scmprisk_Cox}
\title{Copula regression models with Cox margins for semi-competing risk data under right censoring cases}
\source{
Tao Sun, Yunlong Li, Zhengyan Xiao, Ying Ding, Xiaojun Wang (2022).
Semiparametric copula method for semi-competing risks data
subject to interval censoring and left truncation:
Application to disability in elderly. Statistical Methods in Medical Research (Accepted).

Tao Sun, Weijie Liang, Gongzi Zhang, Danhui Yi, Ying Ding, Lihai Zhang (2024).
Penalised semi-parametric copula method for semi-competing risks data:
Application to hip fracture in elderly. Journal of the Royal Statistical Society Series C: Applied Statistics (Accepted)
}
\usage{
rc_scmprisk_Cox(
  data,
  var_list,
  copula_type = "Clayton",
  l1 = 0,
  l2 = 0,
  m1 = 3,
  m2 = 3,
  u1 = NULL,
  u2 = NULL,
  eta_ini_ini = 2,
  method1a1 = "BFGS",
  method1a2 = "BFGS",
  method1b = "BFGS",
  method2 = "BFGS",
  stepsize = 10000,
  initial_par1a1 = NULL,
  initial_par1a2 = NULL
)
}
\arguments{
\item{data}{a data frame. Each row is a single individual with single observation. Must have \code{time1} (time for non-terminal event),
\code{time2} (time for terminal event), \code{status1} (indicator for non-terminal event, 0 if exactly observe, 1 if censored by terminal event, end of cohort or loss to follow-up),
\code{status2} (indicator for terminal event, 0 if exactly observe, 1 if censored by end of cohort or loss to follow-up),
and \code{covariates} by column.}

\item{var_list}{List of covariates to be included in the model.}

\item{copula_type}{The type of copula to use (e.g., "Clayton", "Gumbel").}

\item{l1}{Lower bound for Bernstein polynomial for event 1 (default is 0).}

\item{l2}{Lower bound for Bernstein polynomial for event 2 (default is 0).}

\item{m1}{Order of Bernstein polynomial for event 1 (default is 3).}

\item{m2}{Order of Bernstein polynomial for event 2 (default is 3).}

\item{u1}{Upper bound for Bernstein polynomial for event 1 (default is max(obs_time) + 1).}

\item{u2}{Upper bound for Bernstein polynomial for event 2 (default is max(obs_time) + 1).}

\item{eta_ini_ini}{a vector of initial values for copula parameters, default is 2}

\item{method1a1}{Optimization method for step 1a1 (default is "BFGS").}

\item{method1a2}{Optimization method for step 1a2 (default is "BFGS").}

\item{method1b}{Optimization method for step 1b (default is "BFGS").}

\item{method2}{Optimization method for step 2 (default is "BFGS").}

\item{stepsize}{Maximum number of iterations for optimization steps (default is 10000).}

\item{initial_par1a1}{initial value for parameter when estimating in step 1a_1.}

\item{initial_par1a2}{initial value for parameter when estimating in step 1a_2.}
}
\value{
a \code{CopulaCenR} object summarizing the model.
Can be used as an input to general \code{S3} methods including
\code{summary}, \code{print}, \code{coef},
\code{logLik}, \code{AIC}.
}
\description{
Fits a copula model with Cox margins for semi-competing risk data under right censoring cases.
}
\details{
The input data must be a data frame. Each row is a single individual with single observation. Must have \code{time1} (time for non-terminal event),
\code{time2} (time for terminal event), \code{status1} (indicator for non-terminal event, 0 if exactly observe, 1 if censored by terminal event, end of cohort or loss to follow-up),
\code{status2} (indicator for terminal event, 0 if exactly observe, 1 if censored by end of cohort or loss to follow-up),
and \code{covariates} by column. \cr


The supported copula model in this version is \code{"Clayton"} and \code{"Gumbel"}.
The parametric generator functions of copula functions are list below:

The Clayton copula has a generator \deqn{\phi_{\eta}(t) = (1+t)^{-1/\eta},}
with \eqn{\eta > 0} and Kendall's \eqn{\tau = \eta/(2+\eta)}. \cr

The Gumbel copula has a generator \deqn{\phi_{\eta}(t) = \exp(-t^{1/\eta}),}
with \eqn{\eta \ge 1} and Kendall's \eqn{\tau = 1-1/\eta}. \cr


The marginal Cox semiparametric models are built based on Bernstein polynomials, which is formulated below:

\deqn{S(t|Z) = \exp[-\Lambda(t) e^{Z^{\top}\beta}],} where \eqn{t} is time, \eqn{Z} is covariate,
\eqn{\beta} is the coefficient vector, and \eqn{\Lambda(t)} is the cumulative baseline hazard function.
We approximate \eqn{\Lambda(t)} in a sieve space constructed by Bernstein polynomials with degree \eqn{m}. By default, \eqn{m=3}.
In the end, all model parameters are estimated by the sieve estimators (Sun and Ding, In Press).

The Cox proportional hazards model assumes that the hazard ratio is constant over time, with the form
\eqn{h(t|Z) = h_0(t) e^{Z^{\top}\beta}}, where \eqn{h_0(t)} is the baseline hazard function and \eqn{Z} is the covariate vector.
This formulation is flexible and allows \eqn{\Lambda(t)} to be approximated using Bernstein polynomials, which can be tuned by the degree parameter \code{m}.
The degree of Bernstein polynomial \code{m} can be selected based on the AIC value to provide an optimal balance between model complexity and fit. \cr

Optimization methods can be all methods (except \code{"Brent"}) from \code{optim}, such as
\code{"Nelder-Mead"}, \code{"BFGS"}, \code{"CG"}, \code{"L-BFGS-B"}, \code{"SANN"}.
}
\examples{
# fit a rc_Clayton_Cox model
data("data_scmprisk_rc")
Clayton_rc <- rc_scmprisk_Cox(data_scmprisk_rc,var_list = c("x1","x2","x3"), copula = "Clayton",
              l1=0, m1 = 3,
              l2=0, m2 = 3, eta_ini_ini = 2,method1a1="Nelder-Mead",method1a2="Nelder-Mead"
              )
Clayton_rc
}
