% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstContinuous.R
\name{EstContinuous}
\alias{EstContinuous}
\title{Copula-based estimation of mixed regression models for continuous response}
\usage{
EstContinuous(
  y,
  model,
  family,
  rot = 0,
  clu,
  xc = NULL,
  xm = NULL,
  start = NULL,
  LB = NULL,
  UB = NULL,
  nq = 31,
  dfC = NULL,
  dfM = NULL,
  prediction = TRUE
)
}
\arguments{
\item{y}{n x 1 vector of response variable (assumed continuous).}

\item{model}{function for margins: "gaussian" (normal), "t" (Student with known df=dfM), "laplace" , "exponential", "weibull".}

\item{family}{copula family: "gaussian" (normal), "t" , "clayton" ,  "frank" , "fgm", "gumbel".}

\item{rot}{rotation: 0 (default), 90, 180 (survival), or 270}

\item{clu}{variable of size n defining the clusters; can be a factor}

\item{xc}{covariates of size n for the estimation of the copula, in addition to the constant; default is NULL.}

\item{xm}{covariates of size n for the estimation of the mean of the margin, in addition to the constant; default is NULL.}

\item{start}{starting point for the estimation; default (NULL) are the ones associated with a Gaussian-copula model defined by lme.}

\item{LB}{lower bound for the parameters.}

\item{UB}{upper bound for the parameters.}

\item{nq}{number of nodes and weighted for Gaussian quadrature of the product of conditional copulas; default is 25.}

\item{dfC}{degrees of freedom for a Student margin; default is 5.}

\item{dfM}{degrees of freedom for a Student margin; default is NULL for non-t distribution.}

\item{prediction}{logical variable for prediction of latent variables V; default is TRUE.}
}
\value{
\item{coefficients}{List of estimated parameters: copula, margin, size}

\item{sd}{Standard deviations of the estimated parameters}

\item{tstat}{T statistics for the estimated parameters}

\item{pval}{P-values of the t statistics for the estimated parameters}

\item{gradient}{Gradient of the log-likelihood}

\item{loglik}{Log-likelihood}

\item{aic}{AIC coefficient}

\item{bic}{BIC coefficient}

\item{cov}{Covariance matrix of the estimations}

\item{grd}{Gradients by clusters}

\item{clu}{Cluster values}

\item{Matxc}{Matrix of covariates defining the copula parameters, including a constant}

\item{Matxm}{Matrix of covariates defining the margin parameters, including a constant}

\item{V}{Estimated value of the latent variable by clusters (if prediction=TRUE)}

\item{cluster}{Unique values of clusters}

\item{family}{Copula family}

\item{tau}{Kendall's tau by observation}

\item{thC0}{Estimated parameters of the copula by observation}

\item{thF}{Estimated parameters of the margins by observation}

\item{pcond}{Conditional copula cdf}

\item{fcpdf}{Margin functions (cdf and pdf)}

\item{dfM}{Degrees of freedom for Student margin (default is NULL)}

\item{dfC}{Degrees of freedom for the Student copula (default is NULL)}
}
\description{
This function computes the estimation of a copula-based  2-level hierarchical model.
}
\examples{
data(normal) #simulated data with normal margins
start=c(0,0,0,1); LB=c(rep(-10,3),0.001);UB=c(rep(10,3),10)
y=normal$y; clu=normal$clu;xm=normal$xm
out=EstContinuous(y,model="gaussian",family="clayton",rot=90,clu=clu,xm=xm,start=start,LB=LB,UB=UB)
}
\references{
Krupskii, Nasri & Remillard (2023). On factor copula-based mixed regression models
}
\author{
Pavel Krupskii, Bouchra R. Nasri and Bruno N. Remillard
}
