% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liftChart.R
\name{liftChart}
\alias{liftChart}
\title{Generate a lift chart}
\usage{
liftChart(predTest, depTest, resolution = 1/10)
}
\arguments{
\item{predTest}{Vector with predictions (real-valued or discrete)}

\item{depTest}{Vector with true class labels}

\item{resolution}{Value for the determination of percentile intervals. Default 1/10 (10\%).}
}
\description{
Visualize lift through a lift chart.
}
\examples{
## Load response modeling predictions
data("response")
## Apply liftChart function to visualize lift table results
liftChart(response$test[,2],response$test[,1])

}
\references{
Berry, M.J.A. and Linoff, G.S. (2004): "Data Mining Techniques: For Marketing, Sales, and
Customer Relationship Management - Second Edition". John Wiley & Sons.

Blattberg, R.C., Kim, B.D. and Neslin, S.A. (2008): "Database Marketing: Analyzing and Managing Customers". Springer.
}
\seealso{
\code{\link{topDecileLift}}, \code{\link{liftIndex}}, \code{\link{liftChart}}
}
\author{
Koen W. De Bock, \email{kdebock@audencia.com}
}
