% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/featureSet.R
\name{featureSet}
\alias{featureSet}
\title{DICE Features}
\usage{
featureSet(text, parser = c("none", "spacy"), num_mc_cores = 1)
}
\arguments{
\item{text}{character A vector of texts, each of which will be tallied for politeness features.}

\item{parser}{character Name of dependency parser to use (see details). Without a dependency parser, the politeness features are excluded from the model.}

\item{num_mc_cores}{integer Number of cores for parallelization. Default is 1, but we encourage users to try parallel::detectCores() if possible.}
}
\value{
a data.frame of  features, matching the pre-trained model set
}
\description{
Extracts feature sets to match pre-trained models
}
\details{
The politeness features depend on part-of-speech tagged sentences (e.g. "bare commands" are a particular verb class).
    To include these features in the analysis, a POS tagger must be initialized beforehand - we currently support SpaCy which must
    be installed separately in Python (see example for implementation).
}
