% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{doColumnSearch}
\alias{doColumnSearch}
\alias{doGlobalSearch}
\title{Server-side searching}
\usage{
doColumnSearch(x, search_string, options = list())

doGlobalSearch(data, search_string, options = list())
}
\arguments{
\item{x}{a vector, the type of which determines the expected
\code{search_string} format}

\item{search_string}{a string that determines what to search for. The format
depends on the type of input, matching what a user would type in the
associated filter control.}

\item{options}{a list of options used to control how searching character
values works. Supported options are \code{regex}, \code{caseInsensitive}
and (for global search)
\href{https://datatables.net/reference/option/search.smart}{\code{smart}}.}

\item{data}{a data frame}
}
\value{
An integer vector of filtered row indices
}
\description{
\code{doGlobalSearch()} can be used to search a data frame given the search
string typed by the user into the global search box of a
\code{\link[=datatable]{datatable()}}. \code{doColumnSearch()} does the same for a vector
given the search string typed into a column filter. These functions are used
internally by the default \code{filter} function passed to
\code{\link[=dataTableAjax]{dataTableAjax()}}, allowing you to replicate the search results
that server-side processing returns.
}
\examples{
doGlobalSearch(iris, 'versi')
doGlobalSearch(iris, "v.r.i", options = list(regex = TRUE))

doColumnSearch(iris$Species, '["versicolor"]')
doColumnSearch(iris$Sepal.Length, '4 ... 5')
}
\seealso{
The column filters section online for search string formats:
\url{https://rstudio.github.io/DT/}

Accessing the search strings typed by a user in a Shiny app:
\url{https://rstudio.github.io/DT/shiny.html}
}
