% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/independentCopula.R
\name{independent}
\alias{independent}
\alias{cIndependent}
\alias{crIndependent}
\title{Independence Copula}
\usage{
cIndependent(u1, u2, ...)

crIndependent(numberSimulations = 10000, seed = 42)
}
\arguments{
\item{u1, u2}{points at which to evaluate the copula.}

\item{...}{other parameters.}

\item{numberSimulations}{Number of simulations.}

\item{seed}{Simulation seed, 42 by default.}
}
\value{
Function :
  \itemize{
    \item \code{\link{cIndependent}}  returns the value of the copula.
    \item \code{\link{crIndependent}}  returns simulated values of the copula.
  }
}
\description{
Computes CDF and simulations of the independence copula.
}
\details{
The independence copula has CDF :
  \deqn{C(u_{1}, u_{2}) = u_{1} \times u_{2}}{C(u1, u2) = u1 * u2}
  for \eqn{u_{1}, u_{2} \in [0, 1]}{0 <= u1, u2 <= 1}.
}
\examples{
cIndependent(u1 = .76, u2 = 0.4)

crIndependent(numberSimulations = 10, seed = 42)

}
