% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{loadDrama}
\alias{loadDrama}
\title{Load drama}
\usage{
loadDrama(ids, defaultCollection = "qd")
}
\arguments{
\item{ids}{A vector of ids.}

\item{defaultCollection}{If the ids do not have a collection prefix, the 
defaultCollection prefix is applied.}
}
\value{
The function returns a \code{QDDrama} object. This is essentially a 
list of \code{data.table}s, covering the different aspects (utterances, segments, 
characters, ...). If multiple ids have been supplied as arguments, the tables 
contain the information of multiple plays.
}
\description{
This function loads one or more of the installed plays and 
returns them as a \code{QDDrama} object.
}
\examples{
# both are equivalent
\dontrun{
installData("test")
d <- loadDrama(c("test:rksp.0", "test:rjmw.0"))
d <- loadDrama(c("rksp.0", "rjmw.0"), defaultCollection = "test")
}
}
