% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EFDR_functions.R
\name{wav_th}
\alias{wav_th}
\title{Indices of wavelets exceeding a given threshold}
\usage{
wav_th(Z, wf = "la8", J = 2, th = 1)
}
\arguments{
\item{Z}{image of size \code{n1} by \code{n2} where \code{n1,n2} have to be powers of two}

\item{wf}{type of wavelet to employ. Please see \code{waveslim::wave.filter}  for a full list of wavelet names}

\item{J}{number of resolutions to employ in the wavelet decomposition}

\item{th}{threshold}
}
\value{
Indices of wavelet coefficients in a vector
}
\description{
This function is primarily used for testing the power of a method in the
wavelet domain. Given an image, the discrete wavelet transform is found. 
The indices of the coefficients which exceed a certain threshold are then
considered the 'signal' for testing purposes.
}
\examples{
Z <- test_image(h = 0.5, r = 14, n1 = 64)$z
print(wav_th(Z,wf="la8",J=3,th=0.5))
}
\references{
Shen, X., Huang, H.-C., and Cressie, N. 'Nonparametric hypothesis testing for a spatial signal.' Journal of the American Statistical Association 97.460 (2002): 1122-1140.
}
