% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QRN.R
\name{QRN_seq_predict_foldwise_sep}
\alias{QRN_seq_predict_foldwise_sep}
\title{Sigle-fold foldwise fit-predict function using a recurrent QRN}
\usage{
QRN_seq_predict_foldwise_sep(
  X,
  y,
  q_level,
  n_folds = 3,
  fold_todo = 1,
  number_fits = 3,
  seq_len = 10,
  seed = NULL,
  ...
)
}
\arguments{
\item{X}{Matrix of covariates, for training. Entries must be in sequential order.}

\item{y}{Response variable vector to model the conditional quantile of, for training. Entries must be in sequential order.}

\item{q_level}{Probability level of the desired conditional quantiles to predict.}

\item{n_folds}{Number of folds.}

\item{fold_todo}{Index of the fold to do (integer in 1:n_folds).}

\item{number_fits}{Number of restarts, for stability.}

\item{seq_len}{Data sequence length (i.e. number of past observations) used during training to predict each response quantile.}

\item{seed}{Integer random seed for reproducibility in network weight initialization.}

\item{...}{Other parameters given to \code{\link[=QRN_seq_fit]{QRN_seq_fit()}}.}
}
\value{
A named list containing the foldwise predictions and fits. It namely contains:
\item{predictions}{the numerical vector of quantile predictions for each observation entry in y,}
\item{fits}{a list containing the \code{"QRN_seq"} fitted networks for each fold,}
\item{cuts}{the fold cuts indices,}
\item{folds}{a list of lists containing the train indices, validation indices and fold separations as a list for each fold setup,}
\item{n_folds}{number of folds,}
\item{q_level}{probability level of the predicted quantiles,}
\item{train_losses}{the vector of train losses on each fold,}
\item{valid_losses}{the vector of validation losses on each fold,}
\item{min_valid_losses}{the minimal validation losses obtained on each fold,}
\item{min_valid_e}{the epoch index of the minimal validation losses obtained on each fold.}
}
\description{
Separated single-fold version of \code{\link[=QRN_seq_predict_foldwise]{QRN_seq_predict_foldwise()}}, for computation purposes.
}
