% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN_seq.R
\name{EQRN_fit_seq}
\alias{EQRN_fit_seq}
\title{EQRN fit function for sequential and time series data}
\usage{
EQRN_fit_seq(
  X,
  y,
  intermediate_quantiles,
  interm_lvl,
  shape_fixed = FALSE,
  hidden_size = 10,
  num_layers = 1,
  rnn_type = c("lstm", "gru"),
  p_drop = 0,
  intermediate_q_feature = TRUE,
  learning_rate = 1e-04,
  L2_pen = 0,
  seq_len = 10,
  shape_penalty = 0,
  scale_features = TRUE,
  n_epochs = 500,
  batch_size = 256,
  X_valid = NULL,
  y_valid = NULL,
  quant_valid = NULL,
  lr_decay = 1,
  patience_decay = n_epochs,
  min_lr = 0,
  patience_stop = n_epochs,
  tol = 1e-05,
  orthogonal_gpd = TRUE,
  patience_lag = 1,
  fold_separation = NULL,
  optim_met = "adam",
  seed = NULL,
  verbose = 2,
  device = default_device()
)
}
\arguments{
\item{X}{Matrix of covariates, for training. Entries must be in sequential order.}

\item{y}{Response variable vector to model the extreme conditional quantile of, for training. Entries must be in sequential order.}

\item{intermediate_quantiles}{Vector of intermediate conditional quantiles at level \code{interm_lvl}.}

\item{interm_lvl}{Probability level for the intermediate quantiles \code{intermediate_quantiles}.}

\item{shape_fixed}{Whether the shape estimate depends on the covariates or not (bool).}

\item{hidden_size}{Dimension of the hidden latent state variables in the recurrent network.}

\item{num_layers}{Number of recurrent layers.}

\item{rnn_type}{Type of recurrent architecture, can be one of \code{"lstm"} (default) or \code{"gru"}.}

\item{p_drop}{Probability parameter for dropout before each hidden layer for regularization during training.}

\item{intermediate_q_feature}{Whether to use the \code{intermediate_quantiles} as an additional covariate, by appending it to the \code{X} matrix (bool).}

\item{learning_rate}{Initial learning rate for the optimizer during training of the neural network.}

\item{L2_pen}{L2 weight penalty parameter for regularization during training.}

\item{seq_len}{Data sequence length (i.e. number of past observations) used during training to predict each response quantile.}

\item{shape_penalty}{Penalty parameter for the shape estimate, to potentially regularize its variation from the fixed prior estimate.}

\item{scale_features}{Whether to rescale each input covariates to zero mean and unit covariance before applying the network (recommended).}

\item{n_epochs}{Number of training epochs.}

\item{batch_size}{Batch size used during training.}

\item{X_valid}{Covariates in a validation set, or \code{NULL}. Entries must be in sequential order.
Used for monitoring validation loss during training, enabling learning-rate decay and early stopping.}

\item{y_valid}{Response variable in a validation set, or \code{NULL}. Entries must be in sequential order.
Used for monitoring validation loss during training, enabling learning-rate decay and early stopping.}

\item{quant_valid}{Intermediate conditional quantiles at level \code{interm_lvl} in a validation set, or \code{NULL}.
Used for monitoring validation loss during training, enabling learning-rate decay and early stopping.}

\item{lr_decay}{Learning rate decay factor.}

\item{patience_decay}{Number of epochs of non-improving validation loss before a learning-rate decay is performed.}

\item{min_lr}{Minimum learning rate, under which no more decay is performed.}

\item{patience_stop}{Number of epochs of non-improving validation loss before early stopping is performed.}

\item{tol}{Tolerance for stopping training, in case of no significant training loss improvements.}

\item{orthogonal_gpd}{Whether to use the orthogonal reparametrization of the estimated GPD parameters (recommended).}

\item{patience_lag}{The validation loss is considered to be non-improving
if it is larger than on any of the previous \code{patience_lag} epochs.}

\item{fold_separation}{Index of fold separation or sequential discontinuity in the data.}

\item{optim_met}{DEPRECATED. Optimization algorithm to use during training. \code{"adam"} is the default.}

\item{seed}{Integer random seed for reproducibility in network weight initialization.}

\item{verbose}{Amount of information printed during training (0:nothing, 1:most important, 2:everything).}

\item{device}{(optional) A \code{\link[torch:torch_device]{torch::torch_device()}}. Defaults to \code{\link[=default_device]{default_device()}}.}
}
\value{
An EQRN object of classes \code{c("EQRN_seq", "EQRN")}, containing the fitted network,
as well as all the relevant information for its usage in other functions.
}
\description{
Use the \code{\link[=EQRN_fit_restart]{EQRN_fit_restart()}} wrapper instead, with \code{data_type="seq"}, for better stability using fitting restart.
}
