\name{EQUAL_encrypt_data}
\alias{EQUAL_encrypt_data}
\title{
Encrypt data
}
\description{
"Encrypts data using the public key generated by
\code{\link[=EQUAL_encrypt_generate_keys]{EQUAL_encrypt_generate_keys()}}
function and \pkg{openssl}. This encrypts the file using symmetric AES256
algorithm and encrypts the AES key using the asymmetric RSA algorithm
(4096 bits) and includes padding according to PKCS #1 v2.0 specifications."
}
\usage{
EQUAL_encrypt_data(data, public_key_folder, key_name)
}
\arguments{
\item{data}{Data that must be encrypted}
\item{public_key_folder}{Location of the public key}
\item{key_name}{Name of the public key}
}
\value{
\item{iv}{initialisation vector for AES key}
\item{session}{RSA encrypted AES key}
\item{data}{AES encrypted data}
}
\references{
\url{https://sites.google.com/view/equal-group/home}
}
\author{
Kurinchi Gurusamy
}
\note{
"This is part of a suite of functions required to allow encrypting and
decrypting whole files and encrypting and decrypting columns of data
programs to run. This is unlikely to be used as a stand alone function."
}
\seealso{
\code{\link[=EQUAL_encrypt_generate_keys]{EQUAL_encrypt_generate_keys()}}
\code{\link[openssl:aes_cbc_encrypt]{openssl::aes_cbc_encrypt()}}
\code{\link[openssl:rsa_encrypt]{openssl::rsa_encrypt()}}
}
\concept{EQUALencrypt}
\examples{
library(openssl)
# Encryption keys ####
test_folder <- tempfile(pattern = "folder_")
public_key_folder <- paste0(test_folder, "/public_key_folder")
private_key_folder <- paste0(test_folder, "/private_key_folder")
dir.create(test_folder)
dir.create(public_key_folder)
dir.create(private_key_folder)
encryption_keys <- EQUAL_encrypt_generate_keys(
  public_key_folder = public_key_folder,
  private_key_folder = private_key_folder,
  key_name = "encryption_key.txt")
# Data ####
data <- lapply(1:3, function(x) {
  mean = sample(1:100, 1, replace = FALSE)
  sd = sample(1:100, 1, replace = FALSE)
  rnorm(100, mean = mean, sd = sd)
})
data <- do.call(cbind.data.frame, data)
colnames(data) <- paste0("v", formatC(1:3, width = 6, flag = "0"))
# Encrypt data ####
encrypted_data <- EQUAL_encrypt_data(data = data,
                                     public_key_folder = public_key_folder,
                                     key_name = "encryption_key.txt")

}
