% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/EXRQ.R
\name{select.k.func}
\alias{select.k.func}
\title{Selection of the Tuning Parameter k}
\usage{
select.k.func(y, x, Lam.y, lam, a, max.tau, grid.k, n)
}
\arguments{
\item{y}{a vector of n untransformed responses}

\item{x}{a n x p matrix of n observations and p predictors}

\item{Lam.y}{a vector of n power-transformed responses}

\item{lam}{the power-transformation parameter}

\item{a}{location shift parameter in the power transformation (introduced to avoid negative y values)}

\item{max.tau}{the upper bound of the intermediate quantile levels}

\item{grid.k}{the grid for the number of upper order statistics involved in Hill estimator}

\item{n}{the number of observations}
}
\value{
the selected k is returned
}
\description{
This function selects the tuning parameter k, the number of upper order statistics involved in Hill estimator of EVI among a grid of points
following the method described in Section 3.3 of Wang and Li (2013). The method selects k as the value that minimizes the discrepancy between
the estimated x-dependent EVI on the transformed scale and lam times the estimated x-dependent EVI on the original scale
}
\references{
Wang, H. and Li, D. (2013). Estimation of conditional high quantiles through power transformation. Journal of the American Statistical Association, 108, 1062-1074.
}

