% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_auxiliaryFunctions.R
\name{compute_matrix_alpha}
\alias{compute_matrix_alpha}
\title{Compute the matrix of coefficients alpha}
\usage{
compute_matrix_alpha(kmax, grid, a, d)
}
\arguments{
\item{kmax}{order the derivative that we want to compute}

\item{grid}{the grid of the values at which we want to compute the derivative}

\item{a}{the tuning parameter controlling the bias of the estimator
at zero.}

\item{d}{the dimension of the problem}
}
\value{
a \code{(kmax+1) * (kmax+1) * length(grid)} array
}
\description{
This matrix of coefficient is useful for the estimation of higher-order
derivatives of an elliiptical distribution density generator. It is introduced
in Section 3 of (Ryan and Derumigny, 2024).
}
\examples{
kmax = 1
d = 3
grid = 0.2
a = 0.8
compute_matrix_alpha(kmax = kmax, grid = grid, a = a, d = d)

}
\references{
Ryan, V., & Derumigny, A. (2024).
On the choice of the two tuning parameters for nonparametric estimation of an
elliptical distribution generator
\href{https://arxiv.org/abs/2408.17087}{arxiv:2408.17087}.
}
\seealso{
This function uses the internal functions \code{\link{derivative.tau}}
and \code{\link{derivative.psi}}.
See also \code{\link{vectorized_Faa_di_Bruno}}.
}
\author{
Victor Ryan, Alexis Derumigny
}
\keyword{internal}
