% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALGO__GSA.R
\name{config_gsa}
\alias{config_gsa}
\title{Configuration object for the Gravitational Search Algorithm}
\usage{
config_gsa(
  iterations,
  population_size,
  iterations_same_cost = NULL,
  absolute_tol = NULL,
  grav = 1000,
  grav_evolution = 20
)
}
\arguments{
\item{iterations}{maximum number of iterations.}

\item{population_size}{number of planets.}

\item{iterations_same_cost}{maximum number of consecutive iterations with the \emph{same}
(see the parameter \code{absolute_tol}) best cost before ending the minimization. If \code{NULL} the
minimization continues for the number of iterations specified by the parameter \code{iterations}.
Default is \code{NULL}.}

\item{absolute_tol}{absolute tolerance when comparing best costs from consecutive iterations.
If \code{NULL} the machine epsilon is used. Default is \code{NULL}.}

\item{grav}{gravitational constant, involved in the acceleration of planets.
Default is \code{100}.}

\item{grav_evolution}{parameter to control the exponentially decreasing gravitational constant with
the iterations. Default is \code{20.0}.}
}
\value{
\code{config_gsa} returns an object of class \code{GSAConfig}.
}
\description{
Create a configuration object for the Gravitational Search Algorithm (GSA). At minimum the number of iterations
(parameter \code{iterations}) and the number of planets (parameter \code{population_size}) have
to be provided.
}
\examples{
conf <- config_gsa(iterations = 100, population_size = 50, iterations_same_cost = NULL,
absolute_tol = NULL, grav = 1000, grav_evolution = 20.)

}
\references{
\insertRef{Rashedi2009}{EmiR}
}
