% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envnj.R
\name{env.fasta}
\alias{env.fasta}
\title{Build Trees Based on the Environment Around the Indicated Amino Acid(s)}
\usage{
env.fasta(file, r = 10, aa = 'all', out.file = 'any')
}
\arguments{
\item{file}{path to the single multispecies fasta file to be used as input.}

\item{r}{a positive integer indicating the radius of the sequence segment considered as environment.}

\item{aa}{the amino acid(s) to be used to encoded the species.}

\item{out.file}{path and name of output file. Only if intermediate results data want to be saved (see details).}
}
\value{
A list with two objects, the first one is an inter-species distance matrix. The second one is an object of class 'phylo'.
}
\description{
Builds trees based on the environment around the indicated amino acid(s).
}
\details{
This function builds alignment-independent phylogenetic trees. The input data is a fasta file. When an out.file path is provided, the environment sequences of each species and the vector representing each species are saved in the path provided.
}
\examples{
\dontrun{env.fasta(file = "./data_t/sample5.fasta")}
}
\seealso{
envnj(), fastaconc()
}
