% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kija_rate_test.R
\name{RATETest}
\alias{RATETest}
\title{wrapper for \link[grf]{rank_average_treatment_effect}}
\usage{
RATETest(
  forest,
  priorities,
  level = 0.95,
  cov_type = c("continuous", "discrete"),
  target = c("AUTOC", "QINI"),
  q = seq(0.1, 1, by = 0.1),
  R = 500,
  subset = NULL,
  debiasing.weights = NULL,
  compliance.score = NULL,
  num.trees.for.weights = 500
)
}
\arguments{
\item{forest}{An object of class \code{causal_forest}, as returned by
\link[grf]{causal_forest}().}

\item{priorities}{character, name of covariate to test for heterogeneity.}

\item{level}{numeric, level of RATE confidence interval.}

\item{cov_type}{character, either "continuous" or "discrete". If "discrete",
and q is not manually set, TOC will be evaluated at the quantiles
corresponding to transitions from one level to the next.}

\item{target}{character, see \link[grf]{rank_average_treatment_effect}.}

\item{q}{numeric, see \link[grf]{rank_average_treatment_effect}.}

\item{R}{integer, see \link[grf]{rank_average_treatment_effect}.}

\item{subset}{numeric, see \link[grf]{rank_average_treatment_effect}.}

\item{debiasing.weights}{numeric, see
\link[grf]{rank_average_treatment_effect}.}

\item{compliance.score}{numeric, see
\link[grf]{rank_average_treatment_effect}.}

\item{num.trees.for.weights}{integer, see
\link[grf]{rank_average_treatment_effect}.}
}
\value{
A list of class 'rank_average_treatment_effect' with elements
\itemize{
\item estimate: the RATE estimate.
\item std.err: bootstrapped standard error of RATE.
\item target: the type of estimate.
\item TOC: a data.frame with the Targeting Operator Characteristic curve
estimated on grid q, along with bootstrapped SEs.
\item confint: a data.frame with the lower and upper bounds of the RATE
confidence interval.
\item pval: the p-value for the test that RATE is non-positive.
}
}
\description{
Provides confidence interval and p-value together with the standard output
from \link[grf]{rank_average_treatment_effect}.
}
\examples{
\donttest{
n <- 800
p <- 3
X <- matrix(rnorm(n * p), n, p)
W <- rbinom(n, 1, 0.5)
event_prob <- 1 / (1 + exp(2 * (pmax(2 * X[, 1], 0) * W - X[, 2])))
Y <- rbinom(n, 1, event_prob)
cf <- grf::causal_forest(X, Y, W)
rate <- RATETest(cf, 1)
rate$pval
}

}
\author{
KIJA
}
