% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kija_multi_join.R
\name{multi_join}
\alias{multi_join}
\title{Join many data frames with name handling}
\usage{
multi_join(..., .by)
}
\arguments{
\item{...}{Data frames to join. Each argument in \code{...} must either be
a data.frame or a list of data.frames.}

\item{.by}{A character vector of variables to join by. The \code{.by} must be
present in all data frames in \code{...}.}
}
\value{
The \code{multi_join()} function returns a data frame.
}
\description{
Function to join multiple data.frames with one or more common
variable names.
}
\examples{
# Create some dummy data
testdata_id <- c(1:10)
a1 <- 1:10; b1 <- rep(letters[1:5], times = 2); c1 <- runif(10)
a2 <- 11:20; b2 <- letters[1:10]
a3 <- 21:30; b3 <- rep(letters[11:12], times = 5)
a4 <- 31:40; b4 <- letters[13:22]
a5 <- 41:50; b5 <- letters[11:20]

# Define data.frames with common key and shared column names
data1 <- data.frame(testdata_id, a = a1, b = b1, c = c1)
data2 <- data.frame(testdata_id, b = b2, a = a2)
data3 <- data.frame(testdata_id, a = a3, b = b3)
data4 <- data.frame(testdata_id, a = a4, b = b4)
data5 <- data.frame(testdata_id, a = a5, b = b5)

# multi join
final_data <- multi_join(
  data1,
  data2,
  data3,
  data4,
  data5,
  .by = "testdata_id"
)

}
\author{
KIJA
}
