% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{gp_opts}
\alias{gp_opts}
\title{Approximate Gaussian Process Settings}
\usage{
gp_opts(
  basis_prop = 0.2,
  boundary_scale = 1.5,
  ls_mean = 21,
  ls_sd = 7,
  ls_min = 0,
  ls_max = 60,
  ls = LogNormal(mean = 21, sd = 7, max = 60),
  alpha = Normal(mean = 0, sd = 0.01),
  kernel = c("matern", "se", "ou", "periodic"),
  matern_order = 3/2,
  w0 = 1,
  alpha_mean,
  alpha_sd
)
}
\arguments{
\item{basis_prop}{Numeric, the proportion of time points to use as basis
functions. Defaults to 0.2. Decreasing this value results in a decrease in
accuracy but a faster compute time (with increasing it having the first
effect). In general smaller posterior length scales require a higher
proportion of basis functions. See (Riutort-Mayol et al. 2020
\url{https://arxiv.org/abs/2004.11408}) for advice on updating this default.}

\item{boundary_scale}{Numeric, defaults to 1.5. Boundary scale of the
approximate Gaussian process. See (Riutort-Mayol et al. 2020
\url{https://arxiv.org/abs/2004.11408}) for advice on updating this default.}

\item{ls_mean}{Deprecated; use \code{ls} instead.}

\item{ls_sd}{Deprecated; use \code{ls} instead.}

\item{ls_min}{Deprecated; use \code{ls} instead.}

\item{ls_max}{Deprecated; use \code{ls} instead.}

\item{ls}{A \verb{<dist_spec>} giving the prior distribution of the lengthscale
parameter of the Gaussian process kernel on the scale of days. Defaults to
a Lognormal distribution with mean 21 days, sd 7 days and maximum 60 days:
\code{LogNormal(mean = 21, sd = 7, max = 60)} (a lower limit of 0 will be
enforced automatically to ensure positivity)}

\item{alpha}{A \verb{<dist_spec>} giving the prior distribution of the magnitude
parameter of the Gaussian process kernel. Should be approximately the
expected standard deviation of the Gaussian process (logged Rt in case of
the renewal model, logged infections in case of the nonmechanistic model).
Defaults to a half-normal distribution with mean 0 and sd 0.01:
\code{Normal(mean = 0, sd = 0.01)} (a lower limit of 0 will be enforced
automatically to ensure positivity)}

\item{kernel}{Character string, the type of kernel required. Currently
supporting the Matern kernel ("matern"), squared exponential kernel ("se"),
periodic kernel, Ornstein-Uhlenbeck #' kernel ("ou"), and the periodic
kernel ("periodic").}

\item{matern_order}{Numeric, defaults to 3/2. Order of Matérn Kernel to use.
Common choices are 1/2, 3/2, and 5/2. If \code{kernel} is set
to "ou", \code{matern_order} will be automatically set to 1/2. Only used if
the kernel is set to "matern".}

\item{w0}{Numeric, defaults to 1.0. Fundamental frequency for periodic
kernel. They are only used if \code{kernel} is set to "periodic".}

\item{alpha_mean}{Deprecated; use \code{alpha} instead.}

\item{alpha_sd}{Deprecated; use \code{alpha} instead.}
}
\value{
A \verb{<gp_opts>} object of settings defining the Gaussian process
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Defines a list specifying the structure of the approximate Gaussian
process. Custom settings can be supplied which override the defaults.
}
\examples{
# default settings
gp_opts()

# add a custom length scale
gp_opts(ls = LogNormal(mean = 4, sd = 1, max = 20))

# use linear kernel
gp_opts(kernel = "periodic")
}
