% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-Epoch.r
\name{Epoch}
\alias{Epoch}
\title{Constructor for Epoch class}
\usage{
Epoch(
  table,
  electrodes = NULL,
  times = NULL,
  startTime = NULL,
  samplingRate = NULL,
  rowData = NULL,
  colData = NULL,
  metaData = NULL
)
}
\arguments{
\item{table}{Matrix containing epoch data (rows=electrodes, columns=time points)}

\item{electrodes}{Optional character vector for electrode names, if not provided, row names of data are used. If row names are also not available, there will be no electrode names.}

\item{times}{Optional numeric vector of time points.}

\item{startTime}{Optional numeric value for start time, if provided, times will be calculated based on this and samplingRate.}

\item{samplingRate}{Optional numeric value for sampling rate, if provided, times will be calculated based on this and startTime.}

\item{rowData}{Optional data frame containing metadata for rows (electrodes).}

\item{colData}{Optional data frame containing metadata for columns (time points).}

\item{metaData}{Optional list containing metadata for the Epoch object. Element name "SamplingRate" is reserved by the Epoch class.}
}
\value{
An Epoch object
}
\description{
Constructor for Epoch class
}
\examples{
epoch_data <- matrix(rnorm(1000), nrow = 10)
rownames(epoch_data) <- paste0("Electrode_", 1:10)
epoch <- Epoch(epoch_data, startTime = 0, samplingRate = 100)

}
