% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sim.R
\name{sim_paneldata}
\alias{sim_paneldata}
\title{Simulating a panel data for a binary treatment}
\usage{
sim_paneldata(
  N = 500,
  tt = 5,
  beta = rep(0, tt),
  p = 1,
  gamma = rep(1, p),
  eta = rep(0, N),
  lambda = rep(0, tt),
  het = 0,
  phi = c(0),
  sd = 1,
  burnins = 100
)
}
\arguments{
\item{N}{The number of cross-sectional units in the panel-data}

\item{tt}{The number of time periods in the panel-data}

\item{beta}{The vector of coefficients for the placebo variables. Must be of size tt.}

\item{p}{The number of additional regressors}

\item{gamma}{The vector of coefficients for the additional regressors}

\item{eta}{The vector of fixed effects. Must be of size N.}

\item{lambda}{The vector of time effects. Must be of size tt.}

\item{het}{The heteroskedasticity parameter. Must be 0 or 1: \code{het = 1} indicates that the error terms are generated under heteroskedasticity, \code{het = 0} indicates the error terms are generated under homoscedasticity.}

\item{phi}{The AR(1) parameter for the error terms. Must be in the interval [0,1).}

\item{sd}{The standard deviation of the error terms. Must be a positive number.}

\item{burnins}{The number of burn-ins for the AR(1) process. Must be a positive integer.}
}
\value{
A \code{data.frame} with the following columns:
 \item{ID}{The cross-sectional unit identifier}
 \item{period}{The time period identifier}
 \item{Y}{The dependent variable}
 \item{G}{The binary treatment variable}
 \item{X_1, ..., X_p}{The additional regressors}
}
\description{
sim.paneldata generates a panel data set with N cross-sectional units and tt time periods. The data set includes a binary treatment variable, a set of placebo variables, and a set of additional regressors. The data set can be generated under homoskedasticity or heteroskedasticity, and/or AR(1) errors.
}
\examples{
sim_data <- sim_paneldata(N = 500, tt = 5, beta = rep(0, 5), p=1, 
                          gamma = rep(0,1), het = 1, phi = 0.5, sd = 1, 
                          burnins = 100)
}
