% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitDropout.R
\name{fitDropout}
\alias{fitDropout}
\title{Fit time-to-dropout model}
\usage{
fitDropout(
  df,
  dropout_model = "exponential",
  piecewiseDropoutTime = 0,
  by_treatment = FALSE,
  criterion = "both"
)
}
\arguments{
\item{df}{The subject-level dropout data, including \code{time} and
\code{dropout}. The data should also include \code{treatment}
coded as 1, 2, and so on, and \code{treatment_description}
for fitting the dropout model by treatment.}

\item{dropout_model}{The dropout model used to analyze the dropout data
which can be set to one of the following options: "exponential",
"Weibull", "log-logistic", "log-normal", or "piecewise exponential".
By default, it is set to "exponential".}

\item{piecewiseDropoutTime}{A vector that specifies the time
intervals for the piecewise exponential dropout distribution.
Must start with 0, e.g., c(0, 60) breaks the time axis into 2
event intervals: [0, 60) and [60, Inf). By default, it is set to 0.}

\item{by_treatment}{A Boolean variable to control whether or not to
fit the time-to-dropout data by treatment group. By default,
it is set to \code{FALSE}.}

\item{criterion}{A character variable to denote the criterion in model
selection to shown in the figure, which can be set to one of the following
options: "aic","bic" or "both". By default,it is set to \code{both}.}
}
\value{
A list of results from the model fit including key information
such as the dropout model, \code{model}, the estimated model parameters,
\code{theta}, the covariance matrix, \code{vtheta}, as well as the
Bayesian Information Criterion, \code{bic}, and Akaike Information Criterion, \code{aic}.

If the piecewise exponential model is used, the location
of knots used in the model, \code{piecewiseDropoutTime}, will
be included in the list of results.

When fitting the dropout model by treatment, the outcome is presented
as a list of lists, where each list element corresponds to a
specific treatment group.

The fitted time-to-dropout survival curve is also returned.
}
\description{
Fits a specified time-to-dropout model to the dropout data.
}
\examples{

dropout_fit <- fitDropout(df = interimData2,
                          dropout_model = "exponential")

}
\references{
\itemize{
\item Royston, Patrick, and Mahesh KB Parmar.
"Flexible parametric proportional‐hazards and proportional‐odds models for censored survival data,
with application to prognostic modelling and estimation of treatment effects."
Statistics in medicine 21.15 (2002): 2175-2197.
}
}
