% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WpoisCI.R
\name{WpoisCI}
\alias{WpoisCI}
\title{An Admissible Exact Confidence Interval for the Poisson Mean}
\usage{
WpoisCI(x, conf.level = 0.95, details = FALSE)
}
\arguments{
\item{x}{the sample or the observed point.}

\item{conf.level}{confidence level. The default is 0.95.}

\item{details}{TRUE/FALSE, can be abbreviated. To choose whether to compute
the confidence intervals for all the sample points. Default is FALSE.}
}
\value{
a list which contain the confidence interval and the ICP.
}
\description{
An admissible exact confidence interval for the Poisson mean.
This function can be used to calculate the interval constructed method
proposed by Wang (2014).
}
\details{
Suppose X~poi(lambda), the sample space of X is \{0,1,...\}. Wang
(2014) proposed an admissible interval which is obtained by uniformly
shrinking the initial 1-alpha Clopper-Pearson interval from 0 to the sample
point of interest. This interval is admissible so that any proper
sub-interval of it cannot assure the confidence coefficient. This means the
interval cannot be shortened anymore.
}
\examples{
WpoisCI(1)
WpoisCI(3,details = TRUE)
}
\references{
Wang, W. (2014). An iterative construction of confidence
intervals for a proportion. "Statistica Sinica" 24: 1389-1410.
}
