% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_power.R
\name{average.power.tcorr}
\alias{average.power.tcorr}
\title{Compute average power of many t-tests for non-zero correlation}
\usage{
average.power.tcorr(n, alpha, rho)
}
\arguments{
\item{n}{sample size (scalar)}

\item{alpha}{p-value threshold (scalar)}

\item{rho}{population correlation coefficient (vector)}
}
\value{
Average power estimate for multiple testing procedure
}
\description{
Compute average power of many t-tests for non-zero correlation
}
\details{
For many applications, the null.effect is rho = 0
}
\examples{
rho = rep(c(0.3,0),c(100,900));
average.power.tcorr(n = 50, alpha = 0.05, rho = rho)
}
\seealso{
\code{\link{power.tcorr}} for more details about power calculation of t-test for non-zero correlation
}
