# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Kernel functions
#' @name kernel
#' 
#' @keywords internal
#' 
#' @description
#' Kernel functions transform observed p-values or their support according to
#' \[HLR\], \[PB\] and \[HGR\]. The output is used by [`discrete.LR()`],
#' [`discrete.PB()`] and [`discrete.GR()`], respectively.
#' For each procedure, there is a kernel for fast computation and one for
#' calculation of critical values. Kernel function names followed by `_crit`,
#' e.g. `kernel_DGR_crit`, compute and return these critical values, while
#' kernel functions ending with `_fast` only transform p-values and are
#' therefore faster.
#' 
#' **Note**: As of version 2.0, these functions are purely internal functions!
#' As a consequence, they have to be called directly via `:::`, e.g. 
#' `FDX:::kernel_DGR_fast()`. But users should **not** rely on them, as
#' parameters (including their names, order, etc.) may be changed without
#' notice!
#' 
#' @seealso
#' [`FDX`][`FDX-package`], [`discrete.LR()`]
#' [`discrete.GR()`], [`discrete.PB()`],
#' [`weighted.LR()`], [`weighted.GR()`],
#' [`discrete.PB()`]
#'
#' @templateVar pCDFlist TRUE
#' @templateVar adaptive TRUE
#' @templateVar alpha TRUE
#' @templateVar zeta TRUE
#' @templateVar exact TRUE
#' @templateVar weights FALSE
#' @template param
#' 
#' @param sorted_pv         numeric vector containing the raw p-values, sorted
#'                          in increasing order.
#' @param stepUp            single boolean specifying whether to conduct the
#'                          step-up (`TRUE`) or step-down (`FALSE`; the
#'                          default) version of the discrete Lehmann-Romano
#'                          procedure.
#' @param support           numeric vector, sorted in increasing order, that
#'                          contains the entirety of all observable values of
#'                          the p-value supports; for `kernel_DLR_fast()`, it
#'                          is ignored if `stepUp = FALSE`.
#' @param pCDFcounts        integer vector of counts that indicates to how many
#'                          p-values each **unique** p-value distribution
#'                          belongs.
#' @param sorted_w_pv       numeric vector containing the weighted p-values,
#'                          sorted in increasing order.
#' @param weights           numeric vector containing the **rescaled** weights,
#'                          sorted in **de**creasing order.
#' @param geom_weighting    a boolean specifying whether to conduct geometric
#'                          (`TRUE`) or arithmetic (`FALSE`)
#'                          weighting.
#'
#' @template example
#' @examples \dontrun{
#' 
#' alpha <- 0.05
#' 
#' # If not searching for critical constants, we use only the observed p-values
#' sorted.pvals <- sort(raw.pvalues)
#' y.DLR.fast <- FDX:::kernel_DLR_fast(pCDFlist, sorted.pvals, TRUE)
#' y.NDGR.fast <- FDX:::kernel_DGR_fast(pCDFlist, sorted.pvals, FALSE)$pval.transf
#' # transformed values
#' y.DLR.fast
#' y.NDGR.fast
#' 
#' # compute support
#' pv.list <- sort(unique(unlist(pCDFlist)))
#' y.DGR.crit <- FDX:::kernel_DGR_crit(pCDFlist, pv.list, sorted.pvals, TRUE)
#' y.NDPB.crit <- FDX:::kernel_DPB_crit(pCDFlist, pv.list, sorted.pvals, FALSE)
#' # critical constants
#' y.DGR.crit$crit.consts
#' y.NDPB.crit$crit.consts
#' # transformed values
#' y.DGR.crit$pval.transf
#' y.NDPB.crit$pval.transf
#' }
#' 
#' @return
#' For `*_fast` kernels, a vector of transformed p-values is returned; `*_crit`
#' kernels return a list object with critical constants (`$crit.consts`) and
#' transformed p-values (`$pval.transf`).
#' 
NULL

#' @rdname kernel
kernel_DLR_fast <- function(pCDFlist, sorted_pv, adaptive = TRUE, alpha = 0.05, stepUp = FALSE, zeta = 0.5, support = numeric(), pCDFcounts = NULL) {
    .Call('_FDX_kernel_DLR_fast', PACKAGE = 'FDX', pCDFlist, sorted_pv, adaptive, alpha, stepUp, zeta, support, pCDFcounts)
}

#' @rdname kernel
kernel_DLR_crit <- function(pCDFlist, support, sorted_pv, adaptive = TRUE, alpha = 0.05, zeta = 0.5, stepUp = FALSE, pCDFcounts = NULL) {
    .Call('_FDX_kernel_DLR_crit', PACKAGE = 'FDX', pCDFlist, support, sorted_pv, adaptive, alpha, zeta, stepUp, pCDFcounts)
}

#' @rdname kernel
kernel_wLR_fast <- function(sorted_w_pv, weights, alpha = 0.05, geom_weighting = FALSE) {
    .Call('_FDX_kernel_wLR_fast', PACKAGE = 'FDX', sorted_w_pv, weights, alpha, geom_weighting)
}

#' @rdname kernel
kernel_DGR_fast <- function(pCDFlist, sorted_pv, adaptive = TRUE, alpha = 0.05, pCDFcounts = NULL) {
    .Call('_FDX_kernel_DGR_fast', PACKAGE = 'FDX', pCDFlist, sorted_pv, adaptive, alpha, pCDFcounts)
}

#' @rdname kernel
kernel_DGR_crit <- function(pCDFlist, support, sorted_pv, adaptive = TRUE, alpha = 0.05, zeta = 0.5, pCDFcounts = NULL) {
    .Call('_FDX_kernel_DGR_crit', PACKAGE = 'FDX', pCDFlist, support, sorted_pv, adaptive, alpha, zeta, pCDFcounts)
}

#' @rdname kernel
kernel_wGR_fast <- function(sorted_w_pv, weights, alpha = 0.05, geom_weighting = FALSE) {
    .Call('_FDX_kernel_wGR_fast', PACKAGE = 'FDX', sorted_w_pv, weights, alpha, geom_weighting)
}

#' @rdname kernel
kernel_DPB_fast <- function(pCDFlist, sorted_pv, adaptive = TRUE, alpha = 0.05, exact = TRUE, pCDFcounts = NULL) {
    .Call('_FDX_kernel_DPB_fast', PACKAGE = 'FDX', pCDFlist, sorted_pv, adaptive, alpha, exact, pCDFcounts)
}

#' @rdname kernel
kernel_DPB_crit <- function(pCDFlist, support, sorted_pv, adaptive = TRUE, alpha = 0.05, zeta = 0.5, exact = TRUE, pCDFcounts = NULL) {
    .Call('_FDX_kernel_DPB_crit', PACKAGE = 'FDX', pCDFlist, support, sorted_pv, adaptive, alpha, zeta, exact, pCDFcounts)
}

#' @rdname kernel
kernel_wPB_fast <- function(sorted_w_pv, weights, alpha = 0.05, geom_weighting = FALSE, exact = TRUE) {
    .Call('_FDX_kernel_wPB_fast', PACKAGE = 'FDX', sorted_w_pv, weights, alpha, geom_weighting, exact)
}

geom_weight <- function(pvalues, weights) {
    .Call('_FDX_geom_weight', PACKAGE = 'FDX', pvalues, weights)
}

