% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{clip_predictions}
\alias{clip_predictions}
\title{Clip predictions to observed range}
\usage{
clip_predictions(yhat, y)
}
\arguments{
\item{yhat}{Numeric vector of predicted retention times.}

\item{y}{Numeric vector of observed retention times used to derive bounds.}
}
\value{
Numeric vector of clipped (bounded) predictions.
}
\description{
Clips predicted retention times by fitting a log-normal distribution to the
observed training RTs and bounding predictions to the central 99.99\%
interval. All observed RTs must be positive to estimate the distribution.
If the estimated lower bound would be negative, it is replaced by 1\% of the
observed minimum RT instead.
}
\examples{

# Draw only a few samples (10) and clip based on these. The allowed range will
# be much bigger than the observed range.

set.seed(42)
y <- rlnorm(n = 1000, meanlog = 2, sdlog = 0.1)
yhat <- y
yhat[1] <- -100 # way too low to be realistic
yhat[2] <- 1000 # way too high to be realistic
yhat <- clip_predictions(yhat, y)
range(y)  # [ 6.18,  8.93]
yhat[1:2] # [ 4.96, 10.61] # Limited by theoretical bounds


# Draw more samples (1000) and clip based on these. The allowed range will
# be almost identical to the observed range.

set.seed(42)
y <- rnorm(n = 100, mean = 100, sd = 5)
yhat <- y
yhat[1] <- -100
yhat[2] <- 1000
yhat <- clip_predictions(yhat, y)
range(y)  # 83.14, 117.47
yhat[1:2] # 83.14, 117.72

}
\keyword{public}
