% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{estimate_musseg}
\alias{estimate_musseg}
\title{Estimate fluctuating mean segmentwise given detected change points}
\usage{
estimate_musseg(data, cps, Sig_eta, Sig_nu, Phi, Sig_e1)
}
\arguments{
\item{data}{Numeric matrix of dimension \eqn{n \times p}, representing
the multivariate time series \eqn{\{\mathbf{y}_t\}_{t=1}^n}.}

\item{cps}{Numeric vector of detected change point locations (sorted indices).}

\item{Sig_eta}{Numeric \eqn{p \times p} covariance matrix
\eqn{\Sigma_{\boldsymbol{\eta}}} of the random walk innovation.}

\item{Sig_nu}{Numeric \eqn{p \times p} covariance matrix
\eqn{\Sigma_{\boldsymbol{\nu}}} of the VAR(1) innovation.}

\item{Phi}{Numeric \eqn{p \times p} autoregressive coefficient matrix
\eqn{\Phi}.}

\item{Sig_e1}{Numeric \eqn{p \times p} initial-state covariance matrix
\eqn{\Gamma_{\boldsymbol{\epsilon}}(0)}.}
}
\value{
A numeric matrix of dimension \eqn{n \times p}, containing the estimated
fluctuating mean sequence across all segments.
}
\description{
Estimates the fluctuating mean sequence \eqn{\{\boldsymbol{\mu}_t\}_{t=1}^n}
segmentwise by applying the maximum likelihood estimation (MLE) procedure
within each segment defined by detected change points.
}
\details{
The time series is partitioned into contiguous segments defined by the
specified change points. Within each segment,
\code{\link{estimate_mus}} is applied to obtain the maximum likelihood
estimate of the fluctuating mean sequence for that interval. The resulting
segment-wise estimates are then concatenated to form a complete piecewise
estimate of \eqn{\boldsymbol{\mu}_t} over the entire time series.
}
\examples{
set.seed(123)
p <- 3
mu0 <- rep(0, p)
deltas <- list(c(3, 0, -3), c(-2, 4, 0))
Sig_eta <- diag(0.01, p)
Sig_nu  <- random_Signu(p, 0)
Phi     <- random_Phi(p, p)
Sig_e1  <- get_Sig_e1_approx(Sig_nu, Phi)

# Generate data and estimate mean segmentwise after known CPs
Y <- generate_data(mu0, deltas, Sig_eta, Sig_nu, Phi, Sig_e1,
                   errortype = "n", number_cps = 2, lengthofeachpart = 100)
cps <- c(100, 200)
mu_seg <- estimate_musseg(Y, cps, Sig_eta, Sig_nu, Phi, Sig_e1)
dim(mu_seg)

}
