% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\name{Resp_df}
\alias{Resp_df}
\title{Respiratory Disorder Clinical Trial Data}
\format{
A data frame with 111 observations and 9 variables:
\describe{
  \item{center}{Clinical trial center (factor)}
  \item{treatment}{Treatment group (character)}
  \item{sex}{Sex of the participant (character)}
  \item{age}{Age of the participant (integer)}
  \item{baseline}{Baseline measurement (integer)}
  \item{visit1}{Measurement at visit 1 (integer)}
  \item{visit2}{Measurement at visit 2 (integer)}
  \item{visit3}{Measurement at visit 3 (integer)}
  \item{visit4}{Measurement at visit 4 (integer)}
}
}
\source{
Data taken from the sanon package version 1.6
}
\usage{
data(Resp_df)
}
\description{
This dataset, Resp_df, is a data frame containing repeated measurements from a
clinical trial on respiratory disorders under two treatment conditions.
The dataset records demographic information (center, sex, age), baseline
measures, and follow-up measurements across four visits. It consists of
111 observations and 9 variables. Some observations may contain missing values.
}
\details{
The dataset name has been kept as 'Resp_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ForCausality package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not
been modified in any way.
}
