% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FracField.R
\name{FracField}
\alias{FracField}
\title{FracField}
\usage{
FracField(K, m, H, X)
}
\arguments{
\item{K}{number of observations}

\item{m}{number of criteria}

\item{H}{Hurst parameter (a real in interval [0,1))}

\item{X}{Coordinates}
}
\value{
Returns a fractional Brownian vector field matrix.
}
\description{
Generates fractional Brownian vector field data
}
\examples{
# Load FracKrigingR library
library(FracKrigingR)
# generate Coordinates
   p=2; K=10;
   X<-matrix(0,ncol=p, nrow=K)
   for(j in 1:p){
     for(i in 1:K){
       X[i,j] = rnorm(1, 0, 1)
     }
   }
   # generate fractional Brownian vector field
   H = 0.5; m = 3
   FracField(K,m,H,X)

}
