% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{multitab_to_contrib}
\alias{multitab_to_contrib}
\title{Utility function to convert from multi-table objects to contributional table}
\usage{
multitab_to_contrib(
  func_tab,
  abun_tab,
  ncores = 1,
  samp_colname = "sample",
  func_colname = "function.",
  abun_colname = "taxon_abun",
  taxon_colname = "taxon",
  copy.num_colname = "genome_function_count"
)
}
\arguments{
\item{func_tab}{data.frame object containing function copy numbers, with rows as functions and columns as taxa.}

\item{abun_tab}{data.frame object containing taxonomic abundances across samples, with rows as taxa and columns as samples.}

\item{ncores}{integer specifying number of cores to use for parallizable steps.}

\item{samp_colname}{sample id column name of \code{contrib_tab} output data.frame.}

\item{func_colname}{function id column name of \code{contrib_tab} output data.frame.}

\item{abun_colname}{taxonomic abundance (within each sample) column name of \code{contrib_tab} output data.frame.}

\item{taxon_colname}{taxon id column name of \code{contrib_tab} output data.frame.}

\item{copy.num_colname}{function copy number (within each taxa) column name of \code{contrib_tab} output data.frame.}
}
\value{
data.frame in contributional format (i.e., single, long-format version of both input tables).
}
\description{
Converts from separate taxa abundance and function copy number table input style to contributional-type table (i.e., a single, long table with joint taxa/function information).
}
