% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-evaluate.R
\docType{methods}
\name{evaluate}
\alias{evaluate}
\alias{evaluate,FuzzyNumber,numeric-method}
\title{Evaluate the Membership Function}
\usage{
\S4method{evaluate}{FuzzyNumber,numeric}(object, x)
}
\arguments{
\item{object}{a fuzzy numbers}

\item{x}{numeric vector}
}
\value{
Returns a numeric vector.
}
\description{
This function returns the value(s) of the membership function
of a fuzzy number at given point(s).
}
\examples{
T <- TrapezoidalFuzzyNumber(1,2,3,4)
evaluate(T, seq(0, 5, by=0.5))
}
\seealso{
Other FuzzyNumber-method: 
\code{\link{Arithmetic}},
\code{\link{Extract}},
\code{\link{FuzzyNumber-class}},
\code{\link{FuzzyNumber}},
\code{\link{alphaInterval}()},
\code{\link{alphacut}()},
\code{\link{ambiguity}()},
\code{\link{as.FuzzyNumber}()},
\code{\link{as.PiecewiseLinearFuzzyNumber}()},
\code{\link{as.PowerFuzzyNumber}()},
\code{\link{as.TrapezoidalFuzzyNumber}()},
\code{\link{as.character}()},
\code{\link{core}()},
\code{\link{distance}()},
\code{\link{expectedInterval}()},
\code{\link{expectedValue}()},
\code{\link{integrateAlpha}()},
\code{\link{piecewiseLinearApproximation}()},
\code{\link{plot}()},
\code{\link{show}()},
\code{\link{supp}()},
\code{\link{trapezoidalApproximation}()},
\code{\link{value}()},
\code{\link{weightedExpectedValue}()},
\code{\link{width}()}
}
\concept{FuzzyNumber-method}
\concept{membership_function}
