% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsbootgceclassfunctions.R
\name{confint.tsbootgce}
\alias{confint.tsbootgce}
\title{Confidence Intervals for \code{\link{tsbootgce}} Model Parameters and Normalized
 Entropy}
\usage{
\method{confint}{tsbootgce}(
  object,
  parm,
  level = 0.95,
  which = c("estimates", "NormEnt"),
  method = c("hdr", "percentile", "basic"),
  seed = object$seed,
  ...
)
}
\arguments{
\item{object}{Fitted \code{\link{tsbootgce}} model object.}

\item{parm}{a specification of which parameters are to be given confidence
intervals, either a vector of numbers or a vector of names. If missing,
all parameters are considered.}

\item{level}{the confidence level required. The default is
\code{level = 0.95}.}

\item{which}{One of \code{c("estimates", "NormEnt")}. The default is
\code{which = "estimates"}.}

\item{method}{method used to compute the interval. One of
c("hdr", "percentile", "basic"). The default is \code{method = "hdr"}
(see \code{\link[hdrcde]{hdr}}).}

\item{seed}{A single value, interpreted as an integer, for reproducibility
or \code{NULL} for randomness. The default is \code{seed = object$seed}.}

\item{...}{additional arguments.}
}
\value{
A matrix (or vector) with columns giving lower and upper confidence
limits for each parameter. Generally, these will be labelled as (1-level)/2 and
1 - (1-level)/2 in percentage (by default 2.5 percent and 97.5 percent).
}
\description{
Computes confidence intervals for one or more parameters or Normalized Entropy
in a \code{\link{tsbootgce}} fitted model.
}
\examples{
\donttest{
res.tsbootgce <-
  tsbootgce(
    formula = CO2 ~ 1 + L(GDP, 1) + L(EPC, 1) + L(EU, 1),
    data = moz_ts)

confint(res.tsbootgce, method = "percentile")

confint(res.tsbootgce, which = "NormEnt", level = 0.99)

confint(res.tsbootgce, parm = c("L(GDP, 1)"), level = 0.99)
}

}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
