% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEC_features.R
\name{asymptotic_eep}
\alias{asymptotic_eep}
\title{Asymptotic Wald's test for testing the exponent in a EEP model.}
\usage{
asymptotic_eep(data, eta0, theta1, eta1)
}
\arguments{
\item{data}{Observations.}

\item{eta0}{To test if the exponent equals 1, the default for eta0 is et to be 1.}

\item{theta1}{The unrestricted MLE of theta.}

\item{eta1}{The unrestricted MLE of eta.}
}
\value{
This function returns the test statistic and the p-value of the Wald's test.
}
\description{
This function computes the test statistic and the p-value of Wald's test for the exponent parameter in EEP model.
}
\details{
asymptotic_eep
}
\examples{
sample1 = eep_sampling(200,eta = 1.1,theta = 3)
theta1 = mle_search_eep(data = sample1)$theta
eta1 = mle_search_eep(data = sample1)$eta
asymptotic_eep(sample1,eta0 = 1,theta1,eta1)
}
