#' Sample data (vegnett)
#'
#' Sample of the Norwegian Road Network (`vegnettRuteplan_FGDB_20210528.gdb`) downloaded from Geonorge. Only the first 1000 rows from Oslo county are included.
#'
#' @docType data
#'
#' @usage data(vegnett_sampledata)
#'
#' @format An object of class `sf`.
#'
#' @name vegnett_sampledata
#'
#' @keywords datasets
#'
#' @source \href{https://kartkatalog.geonorge.no/metadata/nvdb-ruteplan-nettverksdatasett/8d0f9066-34f9-4423-be12-8e8523089313/}{National roads database - road network for routing}
#'
#' @examples
#' data(vegnett_sampledata)
#' class(vegnett_sampledata)
#' head(vegnett_sampledata)
NULL


#' Sample data (nodes)
#'
#' Sample of the Norwegian Road Network (`vegnettRuteplan_FGDB_20210528.gdb`) downloaded from Geonorge. Only the first 1000 rows from Oslo county are included.
#'
#' @docType data
#'
#' @usage data(nodes_sampledata)
#'
#' @format An object of class `sf`.
#'
#' @name nodes_sampledata
#'
#' @keywords datasets
#'
#' @source \href{https://kartkatalog.geonorge.no/metadata/nvdb-ruteplan-nettverksdatasett/8d0f9066-34f9-4423-be12-8e8523089313/}{National roads database - road network for routing}
#'
#' @examples
#' data(nodes_sampledata)
#' class(nodes_sampledata)
#' head(nodes_sampledata)
NULL

#' Sample data (edges)
#'
#' Sample of the Norwegian Road Network (`vegnettRuteplan_FGDB_20210528.gdb`) downloaded from Geonorge. Only the first 1000 rows from Oslo county are included.
#'
#' @docType data
#'
#' @usage data(edges_sampledata)
#'
#' @format A data frame
#'
#' @name edges_sampledata
#'
#' @keywords datasets
#'
#' @source \href{https://kartkatalog.geonorge.no/metadata/nvdb-ruteplan-nettverksdatasett/8d0f9066-34f9-4423-be12-8e8523089313/}{National roads database - road network for routing}
#'
#' @examples
#' data(edges_sampledata)
#' class(edges_sampledata)
#' head(edges_sampledata)
NULL

#' Sample data (graph)
#'
#' Sample of the Norwegian Road Network (`vegnettRuteplan_FGDB_20210528.gdb`) downloaded from Geonorge. Only the first 1000 rows from Oslo county are included.
#'
#' @docType data
#'
#' @usage data(graph_sampledata)
#'
#' @format An `igraph` object.
#'
#' @keywords datasets
#'
#' @name graph_sampledata
#'
#' @source \href{https://kartkatalog.geonorge.no/metadata/nvdb-ruteplan-nettverksdatasett/8d0f9066-34f9-4423-be12-8e8523089313/}{National roads database - road network for routing}
#'
#' @examples
#' data(graph_sampledata)
#' class(graph_sampledata)
NULL

#' Sample data (graph_cppRouting_minutes)
#'
#' Sample of the Norwegian Road Network (`vegnettRuteplan_FGDB_20210528.gdb`) downloaded from Geonorge. Only the first 1000 rows from Oslo county are included.
#'
#' @docType data
#'
#' @usage data(graph_cppRouting_minutes_sampledata)
#'
#' @format A `cppRouting` object
#'
#' @name graph_cppRouting_minutes_sampledata
#'
#' @keywords datasets
#'
#' @source \href{https://kartkatalog.geonorge.no/metadata/nvdb-ruteplan-nettverksdatasett/8d0f9066-34f9-4423-be12-8e8523089313/}{National roads database - road network for routing}
#'
#' @examples
#' data(graph_cppRouting_minutes_sampledata)
#' class(graph_cppRouting_minutes_sampledata)
NULL

#' Sample data (graph_cppRouting_meters)
#'
#' Sample of the Norwegian Road Network (`vegnettRuteplan_FGDB_20210528.gdb`) downloaded from Geonorge. Only the first 1000 rows from Oslo county are included.
#'
#' @docType data
#'
#' @usage data(graph_cppRouting_meters_sampledata)
#'
#' @format A `cppRouting` object
#'
#' @name graph_cppRouting_meters_sampledata
#'
#' @keywords datasets
#'
#' @source \href{https://kartkatalog.geonorge.no/metadata/nvdb-ruteplan-nettverksdatasett/8d0f9066-34f9-4423-be12-8e8523089313/}{National roads database - road network for routing}
#'
#' @examples
#' data(graph_cppRouting_meters_sampledata)
#' class(graph_cppRouting_meters_sampledata)
NULL

