% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortest_path_cppRouting.R
\encoding{UTF-8}
\name{shortest_path_cppRouting}
\alias{shortest_path_cppRouting}
\title{Shortest path (cppRouting)}
\usage{
shortest_path_cppRouting(
  from_node_ID,
  to_node_ID,
  unit = "minutes",
  dist = "all",
  graph_cppRouting_object = graph_cppRouting_minutes
)
}
\arguments{
\item{from_node_ID}{Numeric vector with one or more from node ID’s.}

\item{to_node_ID}{Numeric vector with one or more to node ID’s.}

\item{unit}{Character vector with \code{minutes} to calculate the shortest path in minutes or \code{meters} for the shortest path in meters.}

\item{dist}{Character vector that specifies if all the shortest paths between all the supplied from and to nodes are returned (\code{all}), or if only the minimum (\code{min}) or maximum (\code{max}) value for each from node ID is returned.}

\item{graph_cppRouting_object}{The road network structured as a \code{cppRouting} graph object. This can be created with the function \code{\link[=vegnett_to_R]{vegnett_to_R()}}.}
}
\value{
Object (\code{data.frame}) with how many minutes or meters the shortest path is between the supplied from and to node ID’s.
}
\description{
The function \code{shortest_path_cppRouting} can be used to calculate the shortest path (either in minutes or meters) between two or more nodes in the Norwegian road network. The function also works with vectors with multiple from and to node ID’s.
Before the function can be used, the road network must be converted to a \code{cppRouting} object that is called \code{graph_cppRouting_minutes} or \code{graph_cppRouting_meters} (or other with other names supplied to the \code{graph_cppRouting_object} argument). This can be done with the function \code{\link[=vegnett_to_R]{vegnett_to_R()}}.
}
\examples{
shortest_path_cppRouting(from = 25,
                         to = 33,
                         unit = "minutes",
                         graph_cppRouting_object = graph_cppRouting_minutes_sampledata)

shortest_path_cppRouting(from = 25,
                         to = 33,
                         unit = "meters",
                         graph_cppRouting_object = graph_cppRouting_meters_sampledata)

shortest_path_cppRouting(from = 25,
                         to = c(32, 33),
                         unit = "minutes",
                         dist = "min",
                         graph_cppRouting_object = graph_cppRouting_minutes_sampledata)

}
