% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPAGRM.R
\name{SPAGRM.NullModel}
\alias{SPAGRM.NullModel}
\title{Fit SPAGRM null model from residuals and relatedness inputs}
\usage{
SPAGRM.NullModel(
  ResidMatFile,
  SparseGRMFile,
  PairwiseIBDFile,
  control = list(MaxQuantile = 0.75, MinQuantile = 0.25, OutlierRatio = 1.5,
    ControlOutlier = TRUE, MaxNuminFam = 5, MAF_interval = c(1e-04, 5e-04, 0.001, 0.005,
    0.01, 0.05, 0.1, 0.2, 0.3, 0.4, 0.5))
)
}
\arguments{
\item{ResidMatFile}{Data frame or file path with columns \code{SubjID, Resid}.}

\item{SparseGRMFile}{File path to sparse GRM (tab-delimited: ID1, ID2, Value).}

\item{PairwiseIBDFile}{File path to pairwise IBD table (ID1, ID2, pa, pb, pc).}

\item{control}{List of options controlling outlier handling and family
decomposition (see \code{checkControl.SPAGRM.NullModel}).}
}
\value{
A list of class \code{"SPAGRM_NULL_Model"} with elements:
\describe{
\item{Resid}{Numeric vector of residuals used in analysis.}
\item{subjData}{Character vector of subject IDs (length = N).}
\item{N}{Number of subjects.}
\item{Resid.unrelated.outliers}{Residuals of unrelated outlier subjects.}
\item{R_GRM_R}{Sum of quadratic form Resid' * GRM * Resid for all subjects.}
\item{R_GRM_R_TwoSubjOutlier}{Aggregate contribution from two-subject outlier families.}
\item{sum_R_nonOutlier}{Sum of residuals for non-outlier unrelated subjects.}
\item{R_GRM_R_nonOutlier}{Quadratic form contribution for non-outlier unrelated subjects.}
\item{TwoSubj_list}{List with per two-member family residual/Rho info.}
\item{ThreeSubj_list}{List with Chow–Liu tree structures and standardized scores for larger families.}
\item{MAF_interval}{Vector of MAF breakpoints used in tree construction.}
}
}
\description{
Builds the SPAGRM null model object using subject residuals, sparse GRM,
and pairwise IBD estimates, detecting residual outliers and constructing
family-level graph structures for downstream saddlepoint marker tests.
}
