% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.hits.R
\name{count.hits}
\alias{count.hits}
\title{Count Gene Lesion Hits}
\usage{
count.hits(ov.data)
}
\arguments{
\item{ov.data}{A list of six \code{data.frame} objects generated by the \code{find.gene.lsn.overlaps()} function, containing gene-lesion overlap data and supporting indices.}
}
\value{
A list containing the following components:
\item{lsn.data}{Original input lesion data.}
\item{lsn.index}{A \code{data.frame} indexing the rows in \code{gene.lsn.data} that correspond to each lesion.}
\item{gene.data}{Original input gene annotation data.}
\item{gene.index}{A \code{data.frame} indexing the rows in \code{gene.lsn.data} that correspond to each chromosome.}
\item{nhit.mtx}{A \code{data.frame} where rows correspond to genes and columns to lesion types. Each value is the number of hits (lesions) of a certain type affecting the gene.}
\item{nsubj.mtx}{A \code{data.frame} with the same structure as \code{nhit.mtx}, but showing the number of unique subjects with at least one hit of each lesion type per gene.}
\item{gene.lsn.data}{A \code{data.frame} where each row represents a gene overlapped by a lesion. Includes gene name (\code{gene}) and subject ID (\code{ID}).}
\item{glp.data}{A \code{data.frame} ordered by gene and lesion start positions. The \code{cty} column encodes event boundaries: 1 = gene start, 2 = lesion start, 3 = lesion end, 4 = gene end.}
}
\description{
Computes the number of genomic lesions ("hits") affecting each gene by lesion category. It also calculates the number of unique subjects whose lesions overlap each gene by lesion type.
}
\details{
This function summarizes the output of \code{find.gene.lsn.overlaps()} by generating two key matrices:
\itemize{
\item \strong{nsubj.mtx}: For each gene, the number of \emph{unique subjects} with at least one overlapping lesion of each type.
\item \strong{nhit.mtx}: For each gene, the \emph{total number of overlapping lesions} (hits), regardless of subject redundancy, categorized by lesion type.
}

For example, if the gene \strong{NOTCH1} is affected by three separate mutations in the same subject, that subject will be counted once in \code{nsubj.mtx}, but all three hits will be counted in \code{nhit.mtx}.
}
\examples{
data(lesion_data)
data(hg38_gene_annotation)

# Prepare gene and lesion data for GRIN analysis:
prep.gene.lsn <- prep.gene.lsn.data(lesion_data, hg38_gene_annotation)

# Identify overlapping gene-lesion events:
gene.lsn.overlap <- find.gene.lsn.overlaps(prep.gene.lsn)

# Count the number of subjects and lesions (hits) affecting each gene:
count.nsubj.nhits <- count.hits(gene.lsn.overlap)
}
\references{
Pounds, S. et al. (2013). A genomic random interval model for statistical analysis of genomic lesion data.

Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link{prep.gene.lsn.data}}, \code{\link{find.gene.lsn.overlaps}}
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org}, Stanley Pounds \email{stanley.pounds@stjude.org}
}
