% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_instances.R
\name{add_noise}
\alias{add_noise}
\title{Add noise to the VAF values in an F matrix}
\usage{
add_noise(F_matrix, depth, overdispersion, error_rate = 0.001)
}
\arguments{
\item{F_matrix}{A matrix representing the true VAF values of a series of mutations in a set of samples (F matrix).}

\item{depth}{A numeric value representing the mean depth of sequencing.}

\item{overdispersion}{A numeric value representing the overdispersion parameter for the negative binomial distribution used to simulate the depth of sequencing.}

\item{error_rate}{A numeric value specifying the probability of sequencing errors per base. Default is 0.001.}
}
\value{
A matrix containing noisy VAF values of a series of mutations in a set of samples.
}
\description{
This function adds noise to the variant allele frequency (VAF) values in an F matrix, simulating the effect of sequencing errors. The noise is modeled as a negative binomial distribution for the depth of the reads and a binomial distribution for both the variant allele counts and the mismatch counts.
}
\examples{
# Calculate the noisy VAF values of a series of mutations in a set of samples, given the true 
# VAF values in the F matrix F_true, a depth of 30 and an overdispersion of 5

# Simulate the noise-free F matrix of a tumor with 50 clones,
# 10 samples, k = 5, following a positive selection model
F_true <- create_instance(
  n = 50,
  m = 10,
  k = 5,
  selection = "positive", 
  noisy = FALSE)$F_true

# Then we add the noise using a depth of 30 and an overdispersion of 5.
noisy_F <- add_noise(F_true, 30, 5)

}
