% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LongRg.R
\name{LongRg}
\alias{LongRg}
\title{Calculates the longitudinal range in degrees and kilometers, assuming a latitude of 45 degrees for all points by default. Accounts for the possibility of wrapping around the globe.}
\usage{
LongRg(longs, lats = 45)
}
\arguments{
\item{longs}{- Longitudinal occurrences in decimal degrees}

\item{lats}{- A single value representing the latitude to calculate longitudinal distance from or a list of latitudinal coordinates in decimal degrees}
}
\value{
Returns the outermost coordinates of the set, the longitudinal span in degrees and in kilometers
}
\description{
Calculates the longitudinal range in degrees and kilometers, assuming a latitude of 45 degrees for all points by default. Accounts for the possibility of wrapping around the globe.
}
\details{
Calculates the longitudinal range as 360-largest longitudinal gap and accounts for the possbility that a taxon's range wraps around the prime meridian
}
\examples{
longs<-c(133,76,-77,7,-80)
lats<-c(45)
LongRg(longs)
}
