% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate.R
\name{rotate_layout}
\alias{rotate_layout}
\title{Rotate layout positions by a custom angle}
\usage{
rotate_layout(layout, angle)
}
\arguments{
\item{layout}{A 2-column matrix or dataframe of position data, where the columns are the x- and y-coordinates of each node, respectively.}

\item{angle}{The angle by which to rotate the layout, in degrees.}
}
\value{
A matrix of node positions.
}
\description{
This function rotates each node's position by a specified angle.
}
\details{
This function rotates each node position in a 2-column matrix/dataframe of position data by a specified angle.
}
\examples{

# Create a random graph
library(igraph)
g <- sample_gnp(6, 0.05)

# Initializing position vector and plotting
position <- as.matrix(data.frame(X = c(1, 2, 3, 4, 5, 3), Y = c(4, 5, 6, 7, 1, 2)))
plot(g, layout = position)

# Rotating position vector 90 degrees
rotated_df <- rotate_layout(position, 90)

# Updating node position in the graph object
V(g)$x = as.numeric(rotated_df[,1])
V(g)$y = as.numeric(rotated_df[,2])

# Plotting (preserves the exact degree of rotation)
igraph::plot.igraph(g, rescale = FALSE,
                    xlim = range(rotated_df[,1]), ylim = range(rotated_df[,2]))

# Alternatively, GephiForR's easyplot can be used if nodes are assigned a color
V(g)$color <- rainbow(6)
easyplot(g, rotated_df)

# Rotating position vector 283 degrees and plotting
rotated_df <- rotate_layout(position, 283)

# Updating node position in the graph object
V(g)$x = as.numeric(rotated_df[,1])
V(g)$y = as.numeric(rotated_df[,2])

# Plotting (preserves the exact degree of rotation)
igraph::plot.igraph(g, rescale = FALSE,
                    xlim = range(rotated_df[,1]), ylim = range(rotated_df[,2]))

}
