% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_node_colors.R
\name{assign_node_colors}
\alias{assign_node_colors}
\title{Assign node colors based on a set of attributes}
\usage{
assign_node_colors(graph, attributes, custom_colors = NULL)
}
\arguments{
\item{graph}{An \code{igraph} object. The graph must contain a vertex attribute \code{name}.}

\item{attributes}{A two-column matrix or data frame. The first column must contain node names, and the second column must contain the attributes that colors will be assigned off of.}

\item{custom_colors}{A character vector of colors to be used for different attribute values. If not provided, a default palette from \code{rainbow} will be used.}
}
\value{
The input graph with updated vertex color attributes.
}
\description{
This function assigns colors to nodes in a graph based on specified attributes.
}
\examples{
  library(igraph)

  # Creating a sample graph
  g <- sample_gnp(10, 0.3)
  V(g)$name <- letters[1:10]

  # Creating a sample attributes data frame
  attributes <- data.frame(
    Node = letters[1:10],
    Attribute = rep(c("Group1", "Group2", "Group3"), length.out = 10)
  )

  # Assigning node colors using default colors
  g <- assign_node_colors(g, attributes)

  # Plotting the graph
  plot(g, vertex.color = V(g)$color)

  ##### Example with custom colors ####

  # Defining custom colors
  custom_colors <- c("red", "yellow", "pink")

  # Assigning node colors
  g <- assign_node_colors(g, attributes, custom_colors)

  # Plotting the graph
  plot(g, vertex.color = V(g)$color)

}
