% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_book_ids.R
\name{get_book_ids}
\alias{get_book_ids}
\title{Save Book IDs to a Text File}
\usage{
get_book_ids(input_data, file_name)
}
\arguments{
\item{input_data}{A data frame containing a column named book_id.}

\item{file_name}{A string specifying the name of the text file to save the book_id values.}
}
\value{
No return value, the function writes the book_id values to a text file.
}
\description{
This function retrieves the book_id values from the input_data and saves them to a specified text file.
}
\examples{
# Create sample data
books <- data.frame(title = c("Hamlet", "The Hunger Games", "Jane Eyre"),
                    book_id = c("1420", "2767052", "10210")
                    )
# Create a temporary file path
temp_file <- file.path(tempdir(), "bookids.txt")

# Run the function
get_book_ids(books, temp_file)

# Clean up: remove the temporary file
file.remove(temp_file)
}
