% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GoogleImage2array.R
\name{GoogleImage2array}
\alias{GoogleImage2array}
\title{GoogleImage2array: create array from image thumbnails.}
\usage{
GoogleImage2array(
  Query,
  wh = 64,
  Col = TRUE,
  Save = FALSE,
  file_path = NULL,
  gl = "us"
)
}
\arguments{
\item{Query}{a character vector to search images}

\item{wh}{a value of pixels in height and width.}

\item{Col}{a logical. Whether to handle color or gray images.
if TRUE, use color mode.}

\item{Save}{a logical. Whether to save images locally or not.
if TRUE, save locally.}

\item{file_path}{a character. a directory to save the image file.}

\item{gl}{a character to show a region information. ex. us, ja etc}
}
\value{
array
}
\description{
This function is to create the R array/tensor from
2D image obtained from Google image search.
This function provides an array consisted of 20 images per run.
}
\examples{
\donttest{
library(EBImage)

# Simple examples
query <- "persian cat"
CatImg <- GoogleImage2array(query)

#show info
str(CatImg)

query <- "Shiba inu"
DogImg <- GoogleImage2array(query)

#show info
str(DogImg)

#Bind arrays
ImgDat <- EBImage::abind(CatImg$array, DogImg$array, along=1)

#show info
str(ImgDat)

}

}
\author{
Satoshi Kume
}
