% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hima_survival_long.R
\name{hima_survival_long}
\alias{hima_survival_long}
\title{High-dimensional mediation analysis for longitudinal mediator and survival outcome data}
\usage{
hima_survival_long(
  X,
  M,
  tstart,
  tstop,
  status,
  id,
  COV = NULL,
  topN = NULL,
  scale = TRUE,
  Bonfcut = 0.05,
  verbose = FALSE,
  parallel = FALSE,
  ncore = 1
)
}
\arguments{
\item{X}{A numeric vector of exposure values (do not use \code{data.frame} or \code{matrix}).}

\item{M}{A \code{data.frame} or \code{matrix} of high-dimensional mediators (rows = observations/intervals, columns = mediators).}

\item{tstart}{A numeric vector of starting times for each observation/interval (e.g., entry time in a counting-process setup).}

\item{tstop}{A numeric vector of stopping times for each observation/interval (e.g., event/censoring time in a counting-process setup).}

\item{status}{A numeric vector of censoring indicators (\code{1 = event}, \code{0 = censored}).}

\item{id}{A vector of subject identifiers (used for clustering/random effects).}

\item{COV}{A \code{matrix} or \code{data.frame} of adjusting covariates. Rows represent samples, columns represent variables. Can be \code{NULL}.}

\item{topN}{Integer specifying the number of top mediators retained after sure independent screening (SIS). If \code{NULL}
(default), \code{topN = ceiling(n/log(n))}, where \code{n} is the number of unique subjects. When \code{topN} exceeds the
total number of mediators, all mediators are kept (i.e., the low-dimensional scenario).}

\item{scale}{Logical. Should the function scale the exposure, mediators, and covariates? Default = \code{TRUE}.}

\item{Bonfcut}{Bonferroni-corrected p value cutoff applied to select significant mediators. Default = \code{0.05}.}

\item{verbose}{Logical. Should progress messages be printed? Default = \code{FALSE}.}

\item{parallel}{Logical. Enable parallel computing for SIS? Default = \code{FALSE}.}

\item{ncore}{Integer specifying the number of cores to use when \code{parallel = TRUE}.}
}
\value{
A \code{data.frame} containing mediation testing results of significant mediators (joint p-value < \code{Bonfcut}).
\describe{
  \item{Index}{Mediator name of the selected significant mediator.}
  \item{alpha_hat}{Coefficient estimates for the exposure (X) --> mediator (M) model (adjusted for covariates).}
  \item{alpha_se}{Standard error for \code{alpha_hat}.}
  \item{beta_hat}{Coefficient estimates for the mediator (M) --> outcome (Y) model (adjusted for covariates and exposure).}
  \item{beta_se}{Standard error for \code{beta_hat}.}
  \item{IDE}{Indirect (mediation) effect estimate, i.e., \code{alpha_hat * beta_hat}.}
  \item{rimp}{Relative importance of the mediator.}
  \item{pmax}{joint raw p-value of selected significant mediator (based on Bonferroni method).}
}
}
\description{
\code{hima_survival_long} estimates and tests high-dimensional longitudinal mediation effects for survival data in a counting
process framework.
}
\examples{
\dontrun{
data(SurvivalLongData)
pheno_data <- SurvivalLongData$PhenoData
mediator_data <- SurvivalLongData$Mediator

hima_survival_long.fit <- hima_survival_long(
  X = pheno_data$Treatment,
  M = mediator_data,
  tstart = pheno_data$Tstart,
  tstop = pheno_data$Tstop,
  status = pheno_data$Status,
  id = pheno_data$ID,
  COV = pheno_data[, c("Sex", "Age")],
  verbose = TRUE
)
hima_survival_long.fit
}

}
\references{
Liu L, Zhang H, Zheng Y, Gao T, Zheng C, Zhang K, Hou L, Liu L. High-dimensional mediation analysis for longitudinal mediators and 
survival outcomes. Briefings in Bioinformatics. 2025. DOI: 10.1093/bib/bbaf206. PMID: 40350699 PMCID: PMC12066418
}
